/*** 1.   ũƮ ***/

CREATE TABLE TB_Std02 (std_no INT NOT NULL 
	,class_cd VARCHAR(2) NOT NULL
	,code NVARCHAR(36) NOT NULL
	,CONSTRAINT PK_Std02 PRIMARY KEY NONCLUSTERED(std_no))
CREATE TABLE TB_Point02 (std_no INT NOT NULL
	,sbjt_cd varchar(2) NOT NULL
	,point INT NOT NULL) 
INSERT INTO TB_Std02
SELECT std_no
	, CASE WHEN std_no <= 200 THEN '1'
	  WHEN std_no <= 500 THEN '2'
	  WHEN std_no <= 650 THEN '3'
	  ELSE '4' END class_cd
     , CONVERT(NVARCHAR(36),NEWID()) code 
FROM (SELECT ROW_NUMBER() OVER ( ORDER BY a.number) std_no
	FROM master..spt_values a 
	WHERE a.type = 'P'
	AND a.number BETWEEN 1 AND 1000) b

INSERT INTO TB_Point02
SELECT a.std_no, CHAR(b.number + 64) sbjt_cd
	, CASE WHEN a.std_no = 1 THEN 100
	ELSE CONVERT(INT, RIGHT(std_no * ASCII(CONVERT(NVARCHAR(36), NEWID())),2)) END point 
FROM TB_Std02 a, master..spt_values b
WHERE b.type = 'P'
AND b.number BETWEEN 1 AND 4
GO


/*** 2. [AS-IS] SQL    ȹ ***/

SELECT s.std_no, s.class_cd
     , ISNULL(AVG(g.point),0) avg_point
     , COUNT(1) OVER (PARTITION BY class_cd) total_cnt
FROM TB_Std02 s LEFT OUTER JOIN TB_Point02 g 
ON s.std_no = g.std_no
GROUP BY s.std_no,s.class_cd
ORDER BY s.class_cd, avg_point DESC, s.std_no
GO


/*** 6. [TO-BE]   ***/

SELECT a.std_no, a.class_cd, a.avg_point, b.total_cnt
FROM (SELECT s.std_no,s.class_cd,  ISNULL(AVG(g.point), 0) avg_point
	 FROM TB_Std02 s LEFT OUTER JOIN TB_Point02 g 
	 ON s.std_no = g.std_no
	 GROUP BY s.std_no, s.class_cd) a 
INNER JOIN 
     (SELECT class_cd, COUNT(1) total_cnt
	 FROM TB_Std02 
	 GROUP BY class_cd) b
ON a.class_cd = b.class_cd
ORDER BY a.class_cd, avg_point DESC, a.std_no
GO